<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
/**
 * WooCommerce Compatibility File.
 *
 */

if ( ! class_exists( 'solor_theme_woocommerce' ) ) {
	class solor_theme_woocommerce {
		
		private static $instance;
		private $defaults;

		public static function instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}
		
		public function __construct() { 
			$this->defaults = awaiken_generate_defaults();
			add_action( 'init', [ $this, 'alter_wc_hooks' ] );
			add_action( 'widgets_init', [ $this, 'wc_widgets_init' ], 15 );
			add_filter( 'woocommerce_show_page_title', '__return_false' );
			
			// Register customizer controls
			add_action( 'customize_register', [ $this, 'wc_customizer_options' ] );
		}
		
		public static function alter_wc_hooks() {
			remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
		}
		
		public function wc_widgets_init() {
			register_sidebar(
				apply_filters(
					'solor_wc_sidebar',
					array(
						'name' => esc_html__( 'Shop Sidebar', 'solor' ),
						'id' => 'wc-sidebar',
						'description' => esc_html__( 'This sidebar will be used on Shop and Product Taxonomy pages.', 'solor' ),
						'before_widget' => '<aside id="%1$s" class="widget %2$s">',
						'after_widget'  => '</aside>',
						'before_title'  => '<h3 class="widget-title">',
						'after_title'   => '</h3>',
					)
				)
			);
			register_sidebar(
				apply_filters(
					'solor_wc_single_sidebar',
					array(
						'name' => esc_html__( 'Product Sidebar', 'solor' ),
						'id' => 'wc-single-sidebar',
						'description' => esc_html__( 'This sidebar will be used on Single Product pages.', 'solor' ),
						'before_widget' => '<aside id="%1$s" class="widget %2$s">',
						'after_widget'  => '</aside>',
						'before_title'  => '<h3 class="widget-title">',
						'after_title'   => '</h3>',
					)
				)
			);
		}
		
		public function wc_customizer_options( $wp_customize ) { 
			$section	=	'wc_solor_settings';
			
			// Add section to WooCommerce panel
			$wp_customize->add_section( $section , array(
				'title'      => __( 'Solor - Settings', 'solor' ),
				'panel'		=>		'woocommerce',
			) );
			
			//Header Background Image
			$wp_customize->add_setting( 'shop_page_header_background_image',
				array(
					'default' => '',
					'transport' => 'refresh',
					'sanitize_callback' => 'absint'
				)
			);
			
			$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'shop_page_header_background_image',
				array(
					'label' => __( 'Header Background Image', 'solor' ),
					'description' => esc_html__( 'Header background image for shop archive and product single page.', 'solor' ),
					'section' => $section,
					'mime_type' => 'image',
					'button_labels' => array(
						'select' => __( 'Select File', 'solor' ),
						'change' => __( 'Change File', 'solor' ),
						'default' => __( 'Default', 'solor' ),
						'remove' => __( 'Remove', 'solor' ),
						'placeholder' => __( 'No file selected', 'solor' ),
						'frame_title' => __( 'Select File', 'solor' ),
						'frame_button' => __( 'Choose File', 'solor' ),
					)
				)
			) );
			
			// Product list layout
			$wp_customize->add_setting( 'shop_page_layout', array(
			  'default' => $this->defaults['shop_page_layout'],
			   'sanitize_callback' => 'sanitize_text_field',
			) );
			
			$wp_customize->add_control( 'shop_page_layout', array(
				  'label'          => __( 'Shop Archive Layout', 'solor' ),
				  'section' => $section,
				  'settings' => 'shop_page_layout',
				  'type' => 'radio',
				  'choices' => array(
					'full-width'   => __( 'Full Width', 'solor' ),
					'right-sidebar'  => __( 'Right Sidebar', 'solor' ),
					'left-sidebar'  => __( 'Left Sidebar', 'solor' )
				  ),
			) );
			
			// Product list layout
			$wp_customize->add_setting( 'product_single_layout', array(
			  'default' => $this->defaults['product_single_layout'],
			   'sanitize_callback' => 'sanitize_text_field',
			) );
			
			$wp_customize->add_control( 'product_single_layout', array(
				  'label'          => __( 'Product Single Layout', 'solor' ),
				  'section' => $section,
				  'settings' => 'product_single_layout',
				  'type' => 'radio',
				  'choices' => array(
					'full-width'   => __( 'Full Width', 'solor' ),
					'right-sidebar'  => __( 'Right Sidebar', 'solor' ),
					'left-sidebar'  => __( 'Left Sidebar', 'solor' )
				  ),
			) );
			
		}
		
	}
}
solor_theme_woocommerce::instance();