<?php

defined( 'ABSPATH' ) || exit;

function solor_child_theme_enqueue_styles() {
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'theme-style' ), SOLOR_THEME_VERSION ); 
}
add_action( 'wp_enqueue_scripts', 'solor_child_theme_enqueue_styles', 999 );

// Alterar slug e nome do post type 'portfolio'
add_filter( 'register_post_type_args', 'alterar_portfolio_slug_nome', 10, 2 );
function alterar_portfolio_slug_nome( $args, $post_type ) {
    if ( 'awaiken-portfolio' === $post_type ) {
        // Alterar slug (URL)
        $args['rewrite']['slug'] = 'lojas';

        // Alterar labels (nome exibido no admin)
        $args['labels']['name'] = 'Lojas Endesa';
        $args['labels']['singular_name'] = 'Loja Endesa';
        $args['labels']['menu_name'] = 'Lojas Endesa';
        $args['labels']['add_new_item'] = 'Adicionar Nova Loja';
        $args['labels']['edit_item'] = 'Editar Loja';
    }
    return $args;
}

add_filter( 'get_the_archive_title', function( $title ) {
    if ( is_post_type_archive( 'awaiken-portfolio' ) ) {
        return 'Lojas Endesa'; // Novo título
    }
    return $title;
});
